<?php

class StockholmCoreElementorInteractiveBanners extends \Elementor\Widget_Base{
    public function get_name() {
        return 'interactive_banners';
    }

    public function get_title() {
        return esc_html__( "Interactive Banners", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-interactive-banners';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    $this->add_control(
		    'layout_width',
		    [
			    'label' => esc_html__( "Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'one_half'    => esc_html__( '1/2', 'stockholm-core' ),
				    'one_third'   => esc_html__( '1/3', 'stockholm-core' ),
				    'one_fourth'  => esc_html__( '1/4', 'stockholm-core' )
			    ],
			    'default' => 'one_half'
		    ]
	    );
	
	    $this->add_control(
		    'image',
		    [
			    'label' => esc_html__( "Image", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::MEDIA
		    ]
	    );
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);
	
	    $this->add_control(
		    'icon_custom_size',
		    [
			    'label' => esc_html__( "Custom Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( "Default value is 45", 'stockholm-core' ),
			    'condition' => [
				    'icon_pack' => array( 'font_awesome', 'font_elegant', 'linear_icons' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'icon_color',
		    [
			    'label' => esc_html__( "Icon Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	
	    $this->add_control(
		    'title',
		    [
			    'label' => esc_html__( "Title", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	
	    $this->add_control(
		    'title_color',
		    [
			    'label' => esc_html__( "Title Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'title!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'title_size',
		    [
			    'label' => esc_html__( "Title Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( "Default value is 21", 'stockholm-core' ),
			    'condition' => [
				    'title!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'title_tag',
		    [
			    'label' => esc_html__( "Title Tag", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag( false ),
			    'default'  => 'h3',
			    'condition' => [
				    'title!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'subtitle',
		    [
			    'label' => esc_html__( "Subtitle", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	
	    $this->add_control(
		    'subtitle_color',
		    [
			    'label' => esc_html__( "Subtitle Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'subtitle!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'subtitle_size',
		    [
			    'label' => esc_html__( "Subtitle Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( "Defaul value is 17", 'stockholm-core' ),
			    'condition' => [
				    'subtitle!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'subtitle_tag',
		    [
			    'label' => esc_html__( "Subtitle Tag", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag( false ),
			    'default'  => 'h5',
			    'condition' => [
				    'subtitle!' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'content',
		    [
			    'label' => esc_html__( "Content", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::WYSIWYG,
			    'default' => "<p>".esc_html__( 'This is custom text content for shortcode element', 'stockholm-core' )."</p>"
		    ]
	    );
	    
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );
        $params['is_elementor'] = true;
	    $params['link'] = $params['link_color'] = $params['link_border_color'] = $params['link_background_color'] = '';
	    
        if( ! empty($params['image']) ){
            $params['image'] = $params['image']['id'];
        }

        echo stockholm_qode_get_shortcode_template_part('templates/interactive-banners', '_interactive-banners', '', $params);
    }

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorInteractiveBanners() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorInteractiveBanners() );
}