<div class="qode-social-register-holder">
	<form method="post" class="qode-register-form">
		<fieldset>
			<div>
				<input type="text" name="user_register_name" id="user_register_name" placeholder="<?php esc_attr_e( 'User Name', 'select-membership' ) ?>" value="" required pattern=".{3,}" title="<?php esc_attr_e( 'Three or more characters', 'select-membership' ); ?>"/>
			</div>
			<div>
				<input type="email" name="user_register_email" id="user_register_email" placeholder="<?php esc_attr_e( 'Email', 'select-membership' ) ?>" value="" required />
			</div>
            <div>
                <input type="password" name="user_register_password" id="user_register_password" placeholder="<?php esc_attr_e('Password','select-membership') ?>" value="" required />
            </div>
            <div>
                <input type="password" name="user_register_confirm_password" id="user_register_confirm_password" placeholder="<?php esc_attr_e('Repeat Password','select-membership') ?>" value="" required />
            </div>
			<label class="qode-register-privacy-policy">
				<?php
				$privacy_policy_text      = stockholm_qode_membership_theme_installed() ? stockholm_qode_options()->getOptionValue( 'qodef_membership_privacy_policy_text' ) : '';
				$privacy_policy_link      = stockholm_qode_membership_theme_installed() ? stockholm_qode_options()->getOptionValue( 'qodef_membership_privacy_policy_link' ) : '';
				$privacy_policy_link_text = stockholm_qode_membership_theme_installed() ? stockholm_qode_options()->getOptionValue( 'qodef_membership_privacy_policy_link_text' ) : '';
				$privacy_policy_text      = ! empty( $privacy_policy_text ) ? ( esc_html( $privacy_policy_text ) . ' %s.' ) : esc_html__( 'Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our %s.', 'select-membership' );
				$privacy_policy_link      = ! empty( $privacy_policy_link ) ? esc_url( get_permalink( $privacy_policy_link ) ) : esc_url( home_url( '/?page_id=3' ) ); // page id 3 is default terms and condition WordPage page
				$privacy_policy_link_text = ! empty( $privacy_policy_link_text ) ? esc_html( $privacy_policy_link_text ) : esc_html__( 'privacy policy', 'select-membership' );
				echo sprintf(
					$privacy_policy_text,
					'<a itemprop="url" class="qode-register-privacy-policy-link" href="' . $privacy_policy_link . '" target="_blank">' . $privacy_policy_link_text . '</a>'
				);
				?>
			</label>
			<div class="qode-register-button-holder">
				<?php
                echo '<button class="qbutton" type="submit">' . esc_html__( 'REGISTER', 'select-membership' ) . '</button>';

				wp_nonce_field( 'qode-ajax-register-nonce', 'qode-register-security' ); ?>
			</div>
		</fieldset>
	</form>
	<?php do_action( 'stockholm_qode_action_membership_login_ajax_response' ); ?>
</div>