<?php

class StockholmCoreElementorCounter extends \Elementor\Widget_Base{
    public function get_name() {
        return 'counter';
    }

    public function get_title() {
        return esc_html__( "Counter", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-counter';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'type',
            [
                'label' => esc_html__( "Type", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'zero'   => esc_html__( 'Zero Counter', 'stockholm-core' ),
                    'random' => esc_html__( 'Random Counter', 'stockholm-core' ),
                ],
                'default' => 'zero'
            ]
        );

        $this->add_control(
            'box',
            [
                'label' => esc_html__( "Box", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(false, true),
                'default' => 'no'
            ]
        );

        $this->add_control(
            'box_border_color',
            [
                'label' => esc_html__( "Box Border Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'box' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'position',
            [
                'label' => esc_html__( "Position", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'left'   => esc_html__( 'Left', 'stockholm-core' ),
                    'right'  => esc_html__( 'Right', 'stockholm-core' ),
                    'center' => esc_html__( 'Center', 'stockholm-core' ),
                ]
            ]
        );

        $this->add_control(
            'digit',
            [
                'label' => esc_html__( "Digit", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '100'
            ]
        );

        $this->add_control(
            'font_size',
            [
                'label' => esc_html__( "Font size (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'font_weight',
            [
                'label' => esc_html__( "Font weight", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_font_weight_array( true )
            ]
        );

        $this->add_control(
            'font_color',
            [
                'label' => esc_html__( "Font Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( "Text", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'text_size',
            [
                'label' => esc_html__( "Text Size (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'text_font_weight',
            [
                'label' => esc_html__( "Text Font Weight", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_font_weight_array(true)
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__( "Text Transform", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_text_transform_array( true )
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( "Text Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'separator',
            [
                'label' => esc_html__( "Separator", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(false, true)
            ]
        );

        $this->add_control(
            'separator_color',
            [
                'label' => esc_html__( "Separator Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'separator' => 'yes'
                ]
            ]
        );
	
	    $this->add_control(
		    'separator_border_style',
		    [
			    'label' => esc_html__( "Separator Border Style", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'dashed'   => esc_html__( 'Dashed', 'stockholm-core' ),
				    'solid'    => esc_html__( 'Solid', 'stockholm-core' ),
			    ],
			    'condition' => [
				    'separator' => 'yes'
			    ]
		    ]
	    );
	    
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
        $params['content'] = '';
	
	    echo stockholm_qode_get_shortcode_template_part('templates/counter', '_counter', '', $params);
    }

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorCounter() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorCounter() );
}